#include <HardwareSerial.h>
#include "Adafruit_Thermal.h"

HardwareSerial mySerial(1);          // Use UART1 on D6/D7
Adafruit_Thermal printer(&mySerial);

String inputLine = "";

void setup() {
  Serial.begin(115200);              // USB serial for talking from your computer

  // UART on XIAO: D7 = RX, D6 = TX
  mySerial.begin(19200, SERIAL_8N1, RX, TX);
  printer.begin();

  printer.println("Printer ready!");
  printer.feed(2);

  Serial.println("Type a line and press ENTER to print it.");
  Serial.println("(Make sure Serial Monitor is set to 115200 baud.)");
}

void loop() {
  // Read characters from USB Serial
  while (Serial.available() > 0) {
    char c = Serial.read();

    // If you hit Enter (newline), send the line to the printer
    if (c == '\n' || c == '\r') {
      if (inputLine.length() > 0) {
        printer.println(inputLine);
        printer.feed(3);
        inputLine = "";
      }
    } else {
      inputLine += c;
    }
  }
}
